Silex Translation Service
=========================

## Instalation

1) add dependency to composer.json

```json

...
    "repositories": [
        {
            "type": "composer",
            "url": "http://smrtka.gfxpulse.sk/satis/"
        }
    ],
    "require": {
        "silex/silex": "~1.2",
        "gfxpulse/silex-translation-service": "dev-master"
    },
...

```

2) create `cache` directory

3) create `translations` directory, place into eg.: `messages.sk.yml`

4) index.php

```php
<?php

require_once __DIR__ . '/../vendor/autoload.php';

$app = new Silex\Application();

$app['debug'] = true;
$app['cache_dir'] = __DIR__.'/../cache';
$app['translations_dir'] =  __DIR__.'/../translations';
$app['locale'] = "sk";


$app->register(new Gfxpulse\Translation\Provider\TranslationServiceProvider(), array(
        'locale_fallback' => 'en',
    ));

$app['translator'] = $app->share($app->extend('translator', function($translator, $app) {
    $translator->addResource('yaml', $app['translations_dir'].'/messages.sk.yml', 'sk');
    return $translator;
}));

$app->get('/hello/{name}', function($name) use($app) {
    return $app['translator']->trans('Hello %name%', array('%name%' => $app->escape($name)));
});

$app->run();

```
