<?php
/**
 * Created by PhpStorm.
 * Project: moonshine microCMS
 */

namespace Gfxpulse\Thumbmanager\Provider;


use Gfxpulse\Thumbmanager\Controller\ThumbmanagerController;
use Gfxpulse\Thumbmanager\Thumbmanager;
use Gfxpulse\Thumbmanager\Templating\ThumbmanagerExtension;
use Silex\Application;
use Silex\ServiceProviderInterface;
use Symfony\Component\Filesystem\Filesystem;

class ThumbmanagerProvider implements ServiceProviderInterface {

    /**
     * Registers services on the given app.
     *
     * This method should only be used to configure services and parameters.
     * It should not get services.
     *
     * @param Application $app An Application instance
     */
    public function register(Application $app)
    {
        // TODO: refactor
        $app['gfxpulse.thumbmanager.config.source_prefix'] = 'media';
        $app['gfxpulse.thumbmanager.config.thumb_prefix'] = 'media/t';
        $app['gfxpulse.thumbmanager.config.route_pattern'] = '/media/t/{type}/{size}/{path}';

        $app['gfxpulse.thumbmanager.controller'] = $app->share(function() use ($app) {
                return new ThumbmanagerController($app['gfxpulse.thumbmanager']);
            });

        $app['gfxpulse.thumbmanager'] = $app->share(function() use ($app) {

                if (!isset($app['gfxpulse.thumbmanager.config.web_root'])) {
                    throw new \LogicException('You must setup gfxpulse.thumbmanager.config.web_root');
                }

                return new Thumbmanager(
                    new Filesystem(),
                    $app['url_generator'],
                    $app['gfxpulse.thumbmanager.config.web_root'],
                    $app['gfxpulse.thumbmanager.config.source_prefix'],
                    $app['gfxpulse.thumbmanager.config.thumb_prefix']
                );
            });

        if (isset($app['twig'])) {

            $app['gfxpulse.thumbmanager.twig_extension'] = $app->share(function () use ($app) {
                    return new ThumbmanagerExtension($app['gfxpulse.thumbmanager']);
                });

            $app['twig'] = $app->share($app->extend('twig', function (\Twig_Environment $twig) use ($app) {
                    $twig->addExtension($app['gfxpulse.thumbmanager.twig_extension']);

                    return $twig;
                }));
        };
    }

    /**
     * Bootstraps the application.
     *
     * This method is called after all services are registered
     * and should be used for "dynamic" configuration (whenever
     * a service must be requested).
     */
    public function boot(Application $app)
    {

        $app->get($app['gfxpulse.thumbmanager.config.route_pattern'], 'gfxpulse.thumbmanager.controller:thumbnailAction')
            ->assert('path', '.+')
            ->value('type', 1)
            ->bind('gp_thumbnail');


    }
}