<?php

namespace Gfxpulse\Thumbmanager\Controller;

use Gfxpulse\Thumbmanager\ThumbManager;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class ThumbmanagerController
{

    /** @var  ThumbManager */
    protected $thumbManager;

    function __construct(ThumbManager $thumbManager)
    {
        $this->thumbManager = $thumbManager;
    }

    public function thumbnailAction(Request $request)
    {

        $types = array(
            1 => 'adaptiveCrop',
            2 => 'onlyResize'
        );

        $type = $request->get('type');

        if(!isset($types[$type]))
            throw new NotFoundHttpException();

        $webRoot = $this->thumbManager->getWebRootDir();
        $sourceRoot = $this->thumbManager->getSourceRoot();
        //$thumbRoot = $this->thumbManager->getThumbRoot();

        $size = $request->get('size');
        list ($width, $height) = array_map("intval", explode('x', $size));

        $path_info = $request->getPathInfo();

        $requestPath = $request->get('path');

        $path = $sourceRoot.'/'.$requestPath;

        if (!file_exists($path)) {
            throw new NotFoundHttpException('Not valid image path (' . $path_info . ') (' . $path . ')');
        }


        $target_path = rtrim($webRoot.'/'.urldecode(ltrim($path_info,'/')), '/');
        $target_dirname = dirname($target_path);

        $thumb = \PhpThumbFactory::create($path);

        switch ($type) {
            case 1:
                $thumb->adaptiveResize($width, $height);
                break;
            case 2:
                $thumb->resize($width, $height);
                break;
            default:
                throw new NotFoundHttpException();
                break;
        }


        if (!is_dir($target_dirname)) {
            $dir_arr = explode('/', dirname($path_info));
            unset($dir_arr[0]);
            $cur_dir = $webRoot;
            foreach ($dir_arr as $a) {
                $cur_dir .= '/' . $a;
                if (!is_dir($cur_dir)) {
                    @mkdir($cur_dir, 0777, true);
                    @chown($cur_dir, posix_getuid());
                }
            }
        }

        $thumb->save($target_path);
        chown($target_path, posix_getuid());

        header('X-generate: 1');
        $thumb->show();
        exit;
    }
}
