<?php
/**
 * Created by PhpStorm.
 * Project: mpark.sk
 */

namespace Gfxpulse\Thumbmanager;


use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class ThumbManager
 * @package Gfxpulse\Thumbmanager
 */
class Thumbmanager
{

    /**
     * @var \Symfony\Component\Routing\Generator\UrlGeneratorInterface
     */
    protected $generator;

    /**
     * @var \Symfony\Component\Filesystem\Filesystem
     */
    protected $filesystem;

    /**
     * @var string
     */
    protected $webRoot;

    /**
     * @var string
     */
    protected $sourcePrefix;

    /**
     * @var string
     */
    protected $thumbPrefix;

    protected $sourceRoot;

    protected $thumbRoot;


    /**
     * @param Filesystem $filesystem
     * @param UrlGeneratorInterface $generator
     * @param $webRoot
     * @param $sourcePrefix
     * @param $thumbPrefix
     */
    function __construct(Filesystem $filesystem, UrlGeneratorInterface $generator, $webRoot, $sourcePrefix, $thumbPrefix)
    {
        $this->filesystem = $filesystem;
        $this->generator = $generator;

        $this->webRoot = rtrim(str_replace('//', '/', $webRoot), '/');
        $this->sourcePrefix = rtrim(str_replace('//', '/', $sourcePrefix), '/');
        $this->thumbPrefix = ltrim(str_replace('//', '/', $thumbPrefix), '/');
        $this->sourceRoot = rtrim($this->webRoot.'/'.$this->sourcePrefix, '/');
        $this->thumbRoot = rtrim($this->webRoot.'/'.$this->thumbPrefix, '/');
    }

    /**
     * @return mixed
     */
    public function getWebRootDir()
    {
        return $this->webRoot;
    }
    /**
     * @return mixed
     */
    public function getSourceRoot()
    {
        return $this->webRoot.'/'.$this->sourcePrefix;
    }

    /**
     * @return mixed
     */
    public function getThumbRoot()
    {
        return $this->thumbRoot;
    }

    public function getSourcePrefix()
    {
        return $this->sourcePrefix;
    }

    /**
     * @return mixed
     */
    public function getThumbPrefix()
    {
        return $this->thumbPrefix;
    }

    /**
     * @param $path
     * @param array $params
     * @return string
     */
    public function generateUrl($path, array $params = array())
    {
        $params = array_merge(array(
                'path' => $path,
                'type' => 1,
                'size' => '200x150'
            ), $params);

        $thumbUrl = $this->generator->generate('gp_thumbnail', $params, true);

        return $thumbUrl;
    }
}