<?php
/**
 * Created by PhpStorm.
 * Project: mpark.sk
 */

namespace Gfxpulse\Thumbmanager\Templating;


use Gfxpulse\Thumbmanager\ThumbManager;

class ThumbmanagerExtension extends \Twig_Extension
{

    /** @var  ThumbManager */
    private $thumbManager;

    function __construct(ThumbManager $thumbManager)
    {
        $this->thumbManager = $thumbManager;
    }

    /**
     * {@inheritDoc}
     */
    public function getFilters()
    {
        return array(
            'gp_thumb' => new \Twig_Filter_Method($this, 'thumb'),
        );
    }

    public function thumb($path, $size, $type = 1)
    {
        return new \Twig_Markup(
            $this->thumbManager->generateUrl($path, array('size' => $size, 'type' => $type)),
            'utf8'
        );
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return 'thumbmanager';
    }
}