<?php

namespace Weci\DataServiceClient\SnowExtendedClient;

use Weci\DataServiceClient\MainClient\DataProviderClient;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataProviderClientSnow
 *
 * @author Tomas
 */
class DataProviderClientSnowExtended extends DataProviderClient{
    
    private $snowExtendedForecastData;
    
    public function __construct($secret, $url, $clientKey) {
        
        parent::__construct($secret, $url, $clientKey);
        
        $this->snowExtendedForecastData = new ExtendedSnowData();
    }
    
    public function getData($params) {
        
        $data = parent::getData($params);
        
        if($data){

            $this->snowExtendedForecastData->setUnits($data["data"]["units"]);
            
            $this->snowExtendedForecastData->setLatitude($data["data"]["coord"]["lat"]);
            
            $this->snowExtendedForecastData->setLongtitude($data["data"]["coord"]["lng"]);
            
            $this->snowExtendedForecastData->setName($data["data"]["coord"]["name"]);

            $todayForecasts = array();

            foreach($data["data"]["today"] as $tommorowData){

                $forecast = new Forecast();

                $forecast->setTime($tommorowData["time"]);

                $forecast->setTemp($tommorowData["temp"]);

                $forecast->setWindSpeed($tommorowData["windSpeed"]);

                $forecast->setWeatherStatus($tommorowData["weatherStatus"]);

                $forecast->setVisibility($tommorowData["visibility"]);

                $forecast->setCloudCover($tommorowData["cloudCover"]);

                $forecast->setChanceOfSnow($tommorowData["chanceOfSnow"]);

                $forecast->setFreezeLevel($tommorowData["freezeLevel"]);

                $forecast->setSnowFall($tommorowData["snowfall"]);

                $todayForecasts[] = $forecast;

            }

            $this->snowExtendedForecastData->setTodayForecasts($todayForecasts);

            $tommorowForecasts = array();

            foreach($data["data"]["tommorow"] as $tommorowData){

                $forecast = new Forecast();

                $forecast->setTime($tommorowData["time"]);

                $forecast->setTemp($tommorowData["temp"]);

                $forecast->setWindSpeed($tommorowData["windSpeed"]);

                $forecast->setWeatherStatus($tommorowData["weatherStatus"]);

                $forecast->setVisibility($tommorowData["visibility"]);

                $forecast->setCloudCover($tommorowData["cloudCover"]);

                $forecast->setChanceOfSnow($tommorowData["chanceOfSnow"]);

                $forecast->setFreezeLevel($tommorowData["freezeLevel"]);

                $forecast->setSnowFall($tommorowData["snowfall"]);

                $tommorowForecasts[] = $forecast;

            }

            $this->snowExtendedForecastData->setTommorowForecasts($tommorowForecasts);

        }

        return $this->snowExtendedForecastData;
        
    }
    
}

?>
