<?php

namespace Weci\DataServiceClient\MainClient;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of dataProviderComponent
 *
 * @author Tomas
 */
class DataProviderClient {
    
    private $secret;
    
    private $url;
    
    private $clientKey;
    
    public function __construct($secret, $url, $clientKey) {
        
        $this->secret = $secret;
        
        $this->url = $url;
        
        $this->clientKey = $clientKey;
        
    }
    
    public function getData($params){
            
        // nastavi klienta do parametrov URL
        $params["client"] = $this->clientKey;
        
        // nastavi podpis do parametrov URL
        $params["sign"] = $this->calculateSign($params);
        
        // vygenerule URL
        $requestUrl = $this->url.'?'.\http_build_query($params);

        //print_r($requestUrl."<br><br>");
        
        // request
        $response = file_get_contents($requestUrl);
        
        //print_r($response."<br><br>");
        
        $result = json_decode($response, true);
        
        if($result["status"] == 1){
            
            return $result;
            
        }else{
            
            return NULL;
            
        }
        
    }
    
    protected function calculateSign($params){
        
        // nastavi secret do parametrov
        $params["secret"] = $this->secret;
        
        // vygeneruje podpis
        $sign = sha1($this->url."?".http_build_query($params));
        
        // nastavi podpis do parametrov URL
        return $sign;
        
    }
    
}

?>
