<?php

namespace Weci\DataServiceClient\SnowClient;

use Weci\DataServiceClient\MainClient\DataProviderClient;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataProviderClientSnow
 *
 * @author Tomas
 */
class DataProviderClientSnow extends DataProviderClient{
    
    private $snowData;
    
    public function __construct($secret, $url, $clientKey) {
        
        parent::__construct($secret, $url, $clientKey);
        
        $this->snowData = new SnowData();
    }
    
    public function getData($params) {
        
        $data = parent::getData($params);
        
        if($data){
            
            $this->snowData->setLastUpdated($data["data"]["lastUpdated"]);
            
            $this->snowData->setUnits($data["data"]["units"]);
            
            $this->snowData->setLatitude($data["data"]["coord"]["lat"]);
            
            $this->snowData->setLongtitude($data["data"]["coord"]["lng"]);
            
            $this->snowData->setName($data["data"]["coord"]["name"]);
            
            $this->snowData->setSnowConditions($data["data"]["snow"]);
            
            $this->snowData->setSnowDepth($data["data"]["snow"]);

        }

        return $this->snowData;
        
    }
    
}

?>
