<?php

namespace Weci\DataServiceClient\WeatherClient;


use Weci\DataServiceClient\MainClient\DataProviderClient;

/**
 * Description of DataProviderClientSnow
 *
 * @author Tomas
 */
class DataProviderClientWeather extends DataProviderClient{
    
    private $snowData;
    
    public function __construct($secret, $url, $clientKey) {
        
        parent::__construct($secret, $url, $clientKey);
        
        $this->snowData = new WeatherData();
    }
    
    public function getData($params) {
        
        $data = parent::getData($params);
        
        if($data){
            
            $this->snowData->setUnitsName($data["data"]["units"]["name"]);
            
            $this->snowData->setUnitsMark($data["data"]["units"]["mark"]);
            
            $this->snowData->setLatitude($data["data"]["coord"]["lat"]);
            
            $this->snowData->setLongtitude($data["data"]["coord"]["lng"]);
            
            $this->snowData->setName($data["data"]["coord"]["name"]);
            
            if(array_key_exists("now", $data["data"])){
                
                $this->snowData->setNowCurrentTemp($data["data"]["now"]["temp"]["current"]);
            
                $this->snowData->setNowWeatherIcon($data["data"]["now"]["weather"]["icon"]);
            
                $this->snowData->setNowWeatherStatus($data["data"]["now"]["weather"]["status"]);
                
                $this->snowData->setNowLastUpdated($data["data"]["now"]["lastUpdated"]);
                
            }
            
            if(array_key_exists("today", $data["data"])){
                
                $this->snowData->setTodayMorningTemp($data["data"]["today"]["temp"]["morning"]);
                
                $this->snowData->setTodayDayTemp($data["data"]["today"]["temp"]["day"]);
                
                $this->snowData->setTodayEveningTemp($data["data"]["today"]["temp"]["evening"]);
                
                $this->snowData->setTodayNightTemp($data["data"]["today"]["temp"]["night"]);
                
                $this->snowData->setTodayMinTemp($data["data"]["today"]["temp"]["min"]);
                
                $this->snowData->setTodayMaxTemp($data["data"]["today"]["temp"]["max"]);
                
                $this->snowData->setTodayWeatherIcon($data["data"]["today"]["weather"]["icon"]);
                
                $this->snowData->setTodayWeatherStatus($data["data"]["today"]["weather"]["status"]);
                
                $this->snowData->setTodayLastUpdated($data["data"]["today"]["lastUpdated"]);
                
            }
              
            if(array_key_exists("1day", $data["data"])){
                
                $this->snowData->setDay1MorningTemp($data["data"]["1day"]["temp"]["morning"]);
                
                $this->snowData->setDay1DayTemp($data["data"]["1day"]["temp"]["day"]);
                
                $this->snowData->setDay1EveningTemp($data["data"]["1day"]["temp"]["evening"]);
                
                $this->snowData->setDay1NightTemp($data["data"]["1day"]["temp"]["night"]);
                
                $this->snowData->setDay1MinTemp($data["data"]["1day"]["temp"]["min"]);
                
                $this->snowData->setDay1MaxTemp($data["data"]["1day"]["temp"]["max"]);
                
                $this->snowData->setDay1WeatherIcon($data["data"]["1day"]["weather"]["icon"]);
                
                $this->snowData->setDay1WeatherStatus($data["data"]["1day"]["weather"]["status"]);
                
                $this->snowData->setDay1LastUpdated($data["data"]["1day"]["lastUpdated"]);
                
            }
            
            if(array_key_exists("2day", $data["data"])){
                
                $this->snowData->setDay2MorningTemp($data["data"]["2day"]["temp"]["morning"]);
                
                $this->snowData->setDay2DayTemp($data["data"]["2day"]["temp"]["day"]);
                
                $this->snowData->setDay2EveningTemp($data["data"]["2day"]["temp"]["evening"]);
                
                $this->snowData->setDay2NightTemp($data["data"]["2day"]["temp"]["night"]);
                
                $this->snowData->setDay2MinTemp($data["data"]["2day"]["temp"]["min"]);
                
                $this->snowData->setDay2MaxTemp($data["data"]["2day"]["temp"]["max"]);
                
                $this->snowData->setDay2WeatherIcon($data["data"]["2day"]["weather"]["icon"]);
                
                $this->snowData->setDay2WeatherStatus($data["data"]["2day"]["weather"]["status"]);
                
                $this->snowData->setDay2LastUpdated($data["data"]["2day"]["lastUpdated"]);
                
            }
            
        }

        return $this->snowData;

    }
}

?>
