<?php

namespace Weci\DataServiceClient\NameDayClient;

use Weci\DataServiceClient\MainClient\DataProviderClient;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataProviderClientNameDay
 *
 * @author Tomas
 */
class DataProviderClientNameDay extends DataProviderClient{
    
    private $nameDayData;
    
    public function __construct($secret, $url, $clientKey) {
        
        parent::__construct($secret, $url, $clientKey);
        
        $this->nameDayData = new NameDayData();
    }
    
    public function getData($params) {
        
        $data = parent::getData($params);
        
        if($data){
            $this->nameDayData->setNames($data["data"]["names"]);
        
            $this->nameDayData->setHolidays($data["data"]["holidays"]);
        
            $this->nameDayData->setEvents($data["data"]["international"]);
        }
        
        return $this->nameDayData;
        
    }
    
    public function printData(){
        
        print_r("Names <br>");
        foreach ($this->nameDayData->getNames() as $name) {
            print_r($name."<br>");
        }
        
        print_r("Holidays <br>");
        foreach ($this->nameDayData->getHolidays() as $holiday) {
            print_r($holiday."<br>");
        }
        
        print_r("Events <br>");
        foreach ($this->nameDayData->getEvents() as $event) {
            print_r($event."<br>");
        }
        
    }
    
}

?>
